import OrderPage from "@/src/containers/Order";
import { notFound } from "next/navigation";
import React from "react";

function page({
  searchParams,
}: {
  searchParams: { status: string; orderid: string };
}) {
  const { orderid, status } = searchParams;
  if (!(orderid && status)) notFound();

  return <OrderPage orderId={orderid} paymentResult={status === "200"} />;
}

export default page;
