import { cva, type VariantProps } from "class-variance-authority";
import React, { ButtonHTMLAttributes } from "react";
import { ClassNameValue, twMerge } from "tailwind-merge";
import LoaderSpinner from "../LoaderSpinner";

type BtnColors = "primary" | "secondary" | "bordered" | "success" | "outline";

// eslint-disable-next-line no-use-before-define
export type ButtonVariantProps = VariantProps<typeof buttonVariants>;

type Props = Omit<ButtonHTMLAttributes<HTMLButtonElement>, "className"> &
  ButtonVariantProps & {
    children?: React.ReactNode;
    intent?: BtnColors;
    fullWidth?: boolean;
    endIcon?: React.ReactNode;
    className?: ClassNameValue;
    disabled?: boolean; // New: Disabled prop
    isLoading?: boolean; // New: Disabled prop
  };

const buttonVariants = cva(
  "flex h-max items-center justify-center rounded-half px-12 py-4 text-h3  leading-6  lg:px-16 ",
  {
    variants: {
      intent: {
        primary: "bg-primary  text-white disabled:bg-gray-800",
        secondary: "bg-white font-bold text-secondary",
        success: "bg-Success-dark  font-bold text-white",
        outline: "border   border-primary bg-white text-primary",
      },
      fullWidth: {
        true: "w-full",
      },
      disabled: {
        true: "cursor-not-allowed  ",
      },
    },
    defaultVariants: {
      intent: "primary",
    },
  }
);

function Button(props: Props) {
  const {
    children = <></>,
    intent = "primary",
    fullWidth = false,
    isLoading = false,
    className,
    disabled,
    ...rest
  } = props;

  return (
    <button
      className={twMerge(
        buttonVariants({ intent, fullWidth, disabled }),
        className
      )}
      disabled={isLoading || disabled}
      {...rest}
    >
      {isLoading ? <LoaderSpinner /> : children}
    </button>
  );
}

export default Button;
