import React, { useMemo, useState } from "react";
import Image from "next/image";
import LogoImg from "@/public/assets/images/default/placeholder.svg";
import { NextImageProps } from "@/src/types/general";
import { twMerge } from "tailwind-merge";
import Skeleton from "react-loading-skeleton";

function NextImg(props: NextImageProps) {
  const {
    src,
    alt = "",
    skeletonProps = { variant: "rectangular" },
    imgWrapperClassName,
    imgClassName,
    customFallback = LogoImg.src,
    objectFit = "cover",
    width,
    height,
    fill,
    priority,
    imgStyles,
    imgWrapperStyles,
  } = props;

  const fallbackSrc = useMemo(() => customFallback, [customFallback]);

  const [imgStatus, setImgStatus] = useState({
    isLoading: true,
    hasError: false,
  });

  const handleOnError = () => {
    setImgStatus((prevState) => ({
      ...prevState,
      hasError: true,
      isLoading: false,
    }));
  };

  return (
    <div
      className={twMerge("relative  w-full", imgWrapperClassName)}
      style={{
        minHeight: `${height}px`,
        maxWidth: `${width}px`,
        ...imgWrapperStyles,
      }}
    >
      {imgStatus.isLoading && (
        <Skeleton
          style={{
            height: `100%`,
            width: `100%`,
          }}
          className="absolute top-0 z-10  "
          {...skeletonProps}
        />
      )}

      <Image
        priority={priority}
        fill={fill}
        src={imgStatus.hasError || !src ? fallbackSrc : src}
        width={width}
        height={height}
        onLoad={() => {
          setImgStatus((prevState) => ({ ...prevState, isLoading: false }));
        }}
        style={{
          objectFit,
          minHeight: `${height}px`,
          ...imgStyles,
        }}
        className={twMerge("absolute top-0 h-full  w-full", imgClassName)}
        onError={handleOnError}
        alt={imgStatus.hasError ? "broken" : alt}
      />
    </div>
  );
}

export default NextImg;
