import LoaderSpinner from "@/src/components/LoaderSpinner";
import { ServiceDetails } from "@/src/services/httpServices/CartServices/types";
import { Pricing } from "@/src/types/Cart";
import { numberWithCommas } from "@/src/utils/Helpers";

import React, { ReactNode } from "react";

interface Props {
  pricing?: Pricing;
  isLoading: boolean;
  footer: ReactNode;
  showExtraPrice?: boolean;
  adreessResult?:ServiceDetails;
}
function OrderDetailCard({
  pricing,
  isLoading,
  adreessResult,
  footer,
  showExtraPrice = true,
}: Props) {
  
  return (
    <div className="sticky top-0 flex h-max w-full max-w-sm flex-col items-center rounded-half border border-black/20  p-12">
      {isLoading ? (
        <LoaderSpinner className="size-20" />
      ) : (
        <>
          <div className="flex w-full items-center justify-between border-b  p-8">
            <p className="text-h3 ">مجموع : </p>
            <p className="text-h4">
              {numberWithCommas(pricing?.total ?? 0)} تومان
            </p>
          </div>{" "}
          <div className="flex w-full items-center justify-between  p-8">
            <p className="text-h3">مالیات : </p>
            <p className="text-h4">
              {numberWithCommas(pricing?.tax ?? 0)} تومان
            </p>
          </div>
          {pricing?.cashBack !== 0 && (
            <div className="flex w-full items-center justify-between  p-8">
              <p className="text-h3">کش بک : </p>
              <p className="text-h4">
                {numberWithCommas(pricing?.cashBack ?? 0)}- تومان
              </p>
            </div>
          )}
          {showExtraPrice && (
            <>
              <div className="flex w-full items-center justify-between p-8">
                <p className="text-h3">هزینه ارسال : </p>
                <p className="text-h4">
                  {pricing?.sendPrice
                    ? `${numberWithCommas(pricing?.sendPrice ?? 0)} تومان`
                    : "رایگان"}
                </p>
              </div>{" "}
            </>
          )}
          <div className="flex w-full items-center justify-between border-b border-black/20 p-8">
            <p className="text-h3">هزینه بسته بندی : </p>
            <p className="text-h4">
              {pricing?.PackPrice
                ? `${numberWithCommas(pricing?.PackPrice ?? 0)} تومان`
                : "رایگان"}
            </p>
          </div>
          {!!pricing?.discountedPrice && (
            <div className="flex w-full items-center justify-between border-b border-black/20 p-8">
              <p className="text-h3">کد تخفیف : </p>
              <p className="text-h4">
                {numberWithCommas(pricing?.discountedPrice ?? 0)} تومان
              </p>
            </div>
          )}
          <div className="flex w-full items-center justify-between border-b border-black/20 p-8">
            <p className="text-h3">قابل پرداخت : </p>
            <p className="text-h4">
              {numberWithCommas(pricing?.orderTotal ?? 0)} تومان
            </p>
          </div>
          {footer}
        </>
      )}
    </div>
  );
}

export default OrderDetailCard;
