"use client";

import React, { useCallback } from "react";
import { useSearchParams } from "next/navigation";
import Login from "../Login";
import VerifyCode from "../VerfyCode";

function AuthPage() {
  const searchParams = useSearchParams();
  const step = searchParams.get("step") ?? "login";
  const RenderContent = useCallback(() => {
    switch (step) {
      case "login":
        return <Login />;

      case "verify":
        return <VerifyCode />;

      default:
        return <Login />;
    }
  }, [searchParams]);

  return <RenderContent />;
}

export default AuthPage;
