import React from "react";
import { Modal } from "@/src/components/Modal";
import DayTimePickerForm, {
  DayTimePickerDefaultValues,
} from "@/src/components/Share/DayTimePickerForm";
import { DeliveryNextAvailable } from "@/src/hooks/Queries/useDeliveryMethodByTime";
import { convertEnglishWeekdayToPersian } from "@/src/utils/Helpers";
import { useSelectionStore } from "@/src/store/useSelectionStore";

type Props = {
  setShowModalSelectDeliveryTime: React.Dispatch<React.SetStateAction<boolean>>;
  showModalSelectDeliveryTime: boolean;
  deliverynextAvailable: DeliveryNextAvailable | undefined;
  isSuccess: boolean;
  chefId: string;
  isFetching: boolean;
  updateDeliveryTime: (day: string, time: string) => void;
};

const SelectDeliveryTimeModal: React.FC<Props> = ({
  setShowModalSelectDeliveryTime,
  showModalSelectDeliveryTime,
  deliverynextAvailable,
  isSuccess,
  chefId,
  isFetching,
  updateDeliveryTime,
}) => {
  const selection = useSelectionStore((state) => state.getSelection(chefId));
  const deliveryTime = selection?.deliveryTime;
  console.log("🚀 ~ SelectDeliveryTimeModal ~ deliveryTime:", deliveryTime)

  const handleTimeSubmit = ({
    day,
    hour,
    minute,
  }: DayTimePickerDefaultValues) => {
    const time = `${String(hour).padStart(2, "0")}:${String(minute ?? 0).padStart(2, "0")}`;
    updateDeliveryTime(day, `${time}:00`);
    setShowModalSelectDeliveryTime(false);
  };

  const pickerDefaults: DayTimePickerDefaultValues | undefined =
    deliveryTime?.time
      ? {
          day: deliveryTime.day,
          hour: parseInt(deliveryTime.time.split(":")[0], 10),
          minute: parseInt(deliveryTime.time.split(":")[1], 10),
        }
      : undefined;

  return (
    <Modal
      wrapperClassName="max-w-md w-full"
      inlineClassName="h-[400px]"
      open={showModalSelectDeliveryTime}
      title="زمان دریافت سفارش"
      onClose={() => setShowModalSelectDeliveryTime(false)}
    >
      {isSuccess && deliverynextAvailable && (
        <div className="text-warning-dark mb-4 rounded-2 bg-warning-extraLight px-8 py-6 font-iranSans text-body">
          <p className="text-h4 font-bold">
            زمان ارسال در حال حاضر در دسترس نیست.
          </p>
          <p className="mt-4 text-h5">
            اولین زمان ارسال موجود:{" "}
            <span className="font-medium">
              {deliverynextAvailable.service_time_from?.slice(0, 5)} تا{" "}
              {deliverynextAvailable.service_time_to?.slice(0, 5)} -{" "}
              {convertEnglishWeekdayToPersian(deliverynextAvailable.day)}
            </span>
          </p>
        </div>
      )}

      <DayTimePickerForm
        loadingShow={false}
        defaultValues={pickerDefaults}
        onSubmit={handleTimeSubmit}
      />
    </Modal>
  );
};

export default SelectDeliveryTimeModal;
