import {
  ApiComponentExtraData,
  ApiComponentsType,
  ApiComponentVariants,
} from "@/src/services/httpServices/SettingsServices/types";
import React, { useCallback } from "react";

import Offers from "../Offers";
import FoodSlider from "../FoodSlider";
import Banners from "../Banners";
import ItemsSlider from "../ItemsSlider";
import { BannerSlider } from "../BannerSlider";
import ChefRegistration from "../ChefRegistration";

interface Props {
  slug: ApiComponentsType;
  data: ApiComponentExtraData;
  code: string;
}
function ComponentSelector({ slug, data, code }: Props) {
  const Component = useCallback(() => {
    switch (slug) {
      case ApiComponentVariants.DISCOUNT_ONE:
        return (
          <Offers
            bgColor={(data as ApiComponentExtraData).background_color}
            buttonText={(data as ApiComponentExtraData).btn_text_more}
            image={(data as ApiComponentExtraData).image}
            title={(data as ApiComponentExtraData).title}
            code={code}
          />
        );
      case ApiComponentVariants.DISCOUNT_TWO:
        return (
          <Offers
            bgColor={(data as ApiComponentExtraData).background_color}
            buttonText={(data as ApiComponentExtraData).btn_text_more}
            image={(data as ApiComponentExtraData).image}
            title={(data as ApiComponentExtraData).title}
            code={code}
          />
        );
      case ApiComponentVariants.PRODUCT_ONE:
        return (
          <FoodSlider
            title={(data as ApiComponentExtraData).title}
            type="big"
            code={code}
          />
        );
      case ApiComponentVariants.PRODUCT_TWO:
        return (
          <FoodSlider
            title={(data as ApiComponentExtraData).title}
            type="mini"
            code={code}
          />
        );
      case ApiComponentVariants.PRODUCT_THREE:
        return (
          <FoodSlider
            title={(data as ApiComponentExtraData).title}
            type="big"
            code={code}
          />
        );
      case ApiComponentVariants.SINGLE_BANNER:
        return (
          <Banners
            images={data}
            className=" lg:grid-cols-1"
            height={317}
            width={1280}
          />
        );
      case ApiComponentVariants.DOUBLE_BANNER:
        return (
          <Banners
            images={data}
            className=" grid-cols-1 gap-4 lg:grid-cols-2"
            height={255}
          />
        );
      case ApiComponentVariants.TRIPLE_BANNER:
        return (
          <Banners
            images={data}
            className=" grid-cols-3 gap-4 lg:grid-cols-3 "
            height={200}
          />
        );
      case ApiComponentVariants.QUADRUPLE_BANNER:
        return (
          <Banners
            images={data}
            className=" grid-cols-2  gap-4 lg:h-[255px] lg:grid-cols-4"
            height={255}
          />
        );
      case ApiComponentVariants.QUINTUPLE_BANNER:
        return (
          <Banners
            images={data}
            className=" grid-cols-2 gap-4 lg:h-[255px] lg:grid-cols-5 "
            height={255}
          />
        );
      case ApiComponentVariants.HEXTUPLE_BANNER:
        return (
          <Banners
            images={data}
            className=" grid-cols-3 gap-4 lg:h-[200px] lg:grid-cols-6"
            height={200}
          />
        );
      case ApiComponentVariants.SINGLE_SLIDER:
        return (
          <BannerSlider
            images={data}
            className="h-[350px]  "
            breakpoints={{}}
          />
        );
      case ApiComponentVariants.DOUBLE_SLIDER:
        return (
          <BannerSlider
            className="h-80 lg:h-[255px]"
            images={data}
            breakpoints={{
              240: {
                slidesPerView: 1.5,
                spaceBetween: 10,
              },

              540: {
                slidesPerView: 1.5,
                spaceBetween: 10,
              },
              670: {
                slidesPerView: 2,
                spaceBetween: 8,
              },
            }}
          />
        );
      case ApiComponentVariants.TRIPPLE_SLIDER:
        return (
          <BannerSlider
            images={data}
            className="h-[255px]"
            breakpoints={{
              240: {
                slidesPerView: 2,
                spaceBetween: 10,
              },

              540: {
                slidesPerView: 2,
                spaceBetween: 10,
              },
              670: {
                slidesPerView: 3,
                spaceBetween: 8,
              },
            }}
          />
        );
      case ApiComponentVariants.QUADRUPLE_SLIDER:
        return (
          <BannerSlider
            images={data}
            className="h-[255px]"
            breakpoints={{
              240: {
                slidesPerView: 2,
                spaceBetween: 10,
              },

              540: {
                slidesPerView: 3,
                spaceBetween: 10,
              },
              670: {
                slidesPerView: 4,
                spaceBetween: 8,
              },
            }}
          />
        );
      case ApiComponentVariants.QUINTUPLE_SLIDER:
        return (
          <BannerSlider
            images={data}
            className="h-[255px]"
            breakpoints={{
              240: {
                slidesPerView: 3,
                spaceBetween: 10,
              },

              540: {
                slidesPerView: 4,
                spaceBetween: 10,
              },
              670: {
                slidesPerView: 5,
                spaceBetween: 8,
              },
            }}
          />
        );
      case ApiComponentVariants.HEXTUPLE_SLIDER:
        return (
          <BannerSlider
            images={data}
            className="h-[200px]"
            breakpoints={{
              240: {
                slidesPerView: 4,
                spaceBetween: 10,
              },

              540: {
                slidesPerView: 5,
                spaceBetween: 10,
              },
              670: {
                slidesPerView: 6,
                spaceBetween: 8,
              },
            }}
          />
        );
      case ApiComponentVariants.SELLER_ONE:
        return (
          <ItemsSlider code={code} extraData={data as ApiComponentExtraData} />
        );
      case ApiComponentVariants.REGISTRATION:
        return (
          <ChefRegistration
            btnText={(data as ApiComponentExtraData).btn_text}
            description={(data as ApiComponentExtraData).text}
            sellerTitle={(data as ApiComponentExtraData).sub_description}
            image={(data as ApiComponentExtraData).image}
            title={(data as ApiComponentExtraData).title}
          />
        );

      default:
        return <>unknown component {slug} </>;
    }
  }, []);
  console.log(slug);
  return (
    <>
      <Component />
    </>
  );
}

export default ComponentSelector;
