import React from "react";
import dynamic from "next/dynamic";

const UserActions = dynamic(() => import("../Header/UserActions"), {
  ssr: false,
});

function MobileHeader() {
  return (
    <div className="block w-full min-w-full border-b border-black/20 bg-white lg:hidden">
      {/*
        در موبایل، متن هدر نباید truncate شود.
        برای اینکه متن کامل (در یک سطر) دیده شود، یک سطر مستقل برای آن در نظر می‌گیریم.
      */}
      <div className="container flex flex-col gap-2 px-10 py-3 lg:hidden lg:px-0">
        <div className="flex items-center justify-end">
          <UserActions />
        </div>
        <p className="w-full whitespace-nowrap text-sm font-bold text-primary">
          فضایی برای معاشرت،نوشیدن، کار و خاطره سازی ...
        </p>
      </div>
    </div>
  );
}

export default MobileHeader;
