"use client";

import React, { ReactNode, useMemo } from "react";

import {
  noHeaderRouts,
  noFooterRouts,
  noMobileHeaderRouts
} from "@/src/configs";
import { usePathname } from "next/navigation";
import { useSettingsStore } from "@/src/providers/SettingsProvider";
import { ApiPageItem } from "@/src/services/httpServices/SettingsServices/types";

import Link from "next/link";
import UseCartStore from "@/src/store/UseCartStore";
import MobileHeader from "./MobileHeader";
import Header from "./Header";
import Footer from "./Footer";

interface Props {
  children: ReactNode;
  pages: ApiPageItem[];
}

function LayoutProvider({ children, pages }: Props) {
  const path = usePathname();
  const settings = useSettingsStore((state) => state.settings);
  const homePageSingle = useMemo(
    () => settings.mode === "single" && path === "/",
    [path, settings.mode]
  );
  const { cardItems } = UseCartStore();
  const showChefCheckout = !!cardItems.length && path.startsWith("/chef") && path !== "/cart" && !path.startsWith("/auth");

  // در موبایل، نوار پایینِ «تکمیل سفارش» fixed است؛
  // برای اینکه محتوا زیر آن پنهان نشود (و در iOS هم با safe-area تداخل نداشته باشد)
  // برای main و خود نوار پایین padding مناسب در نظر می‌گیریم.
  const mainStyle: React.CSSProperties | undefined = showChefCheckout
    ? { paddingBottom: "calc(8rem + env(safe-area-inset-bottom))" }
    : undefined;

  return (
    <>
      {!noHeaderRouts.find(
        (route) => path === route || path.startsWith(route)
      ) &&
        !homePageSingle && (
          <>
            <div className="hidden lg:block"><Header /></div>
          </>
        )}
      {!noMobileHeaderRouts.find(
        (route) => path === route || path.startsWith(route)
      ) && (
        <>
          <div className="lg:hidden"><MobileHeader /></div>
        </>
      )}
      <main className="relative min-h-screen bg-white" style={mainStyle}>
        {children}
      </main>
      {showChefCheckout && (
        <div
          className="fixed bottom-0 left-0 right-0 z-50 border-t border-black/10 bg-white p-3 lg:hidden"
          style={{ paddingBottom: "calc(0.75rem + env(safe-area-inset-bottom))" }}
        >
          <Link
            href="/cart"
            className="block w-full rounded-half bg-primary py-4 text-center text-h4 font-bold text-white"
          >
            تکمیل سفارش
          </Link>
        </div>
      )}

      {!!cardItems.length && path !== "/cart" && !path.startsWith("/auth") && !path.startsWith("/chef") && (
        <div className="fixed bottom-40 left-12 z-50 lg:bottom-12">
          <Link
            href="/cart"
            className="    w-max rounded-half border-black/20 bg-primary p-4 text-h5 font-bold  text-white  "
          >
            تکمیل سفارش ({cardItems.length ?? 0})
          </Link>
        </div>
      )}
      {!noFooterRouts.find(
        (route) => path === route || path.startsWith(route)
      ) && (
        <>
          <Footer pages={pages} />
        </>
      )}
</>
  );
}

export default LayoutProvider;
