"use client";

import NextImg from "@/src/components/NextImage";
import { usePostsListQuery } from "@/src/hooks/Queries";
import { Post } from "@/src/types/Post";

import Link from "next/link";
import React from "react";
import PostCategorySlider from "./PostCategorySlider";

interface Props {
  postData: Post;
}

function PostDetail({ postData }: Props) {
  const { data, isLoading } = usePostsListQuery({
    categoryID: postData.category.id,
  });

  return (
    <div className="container">
      <div className="grid w-full grid-cols-12 gap-10">
        <div className="col-span-12 flex flex-col gap-12 lg:col-span-8">
          <div className="flex flex-col gap-8 ">
            <NextImg
              src={postData.cover}
              width={900}
              height={500}
              alt={postData.title}
            />
            <Link
              href={`/post/?categoryId=${postData.category.id}`}
              className="text-h5 text-black/70"
            >
              {postData.category.title}
            </Link>
          </div>
          <h1 className="text-h2 font-bold">{postData.title}</h1>
          <div dangerouslySetInnerHTML={{ __html: postData.content }} />
        </div>
        <div className="col-span-12 lg:col-span-4 ">
          <div className="flex w-auto max-w-max  items-center gap-4 whitespace-nowrap border-b border-primary">
            <p className=" text-h2 font-bold ">مقالات مشابه</p>
          </div>
          {!isLoading && (
            <>
              <div className="col-span-4  hidden flex-col py-10 lg:flex ">
                {data?.data?.map((post) => (
                  <Link
                    href={`/post/${post.id}`}
                    key={post.id}
                    className="flex flex-col gap-8 border-b border-black/20 bg-white  py-2 "
                  >
                    <div className="flex w-full cursor-pointer  gap-4">
                      <NextImg
                        src={post.cover}
                        width={120}
                        imgClassName="rounded-base "
                        height={80}
                        alt="img"
                      />

                      <p className=" line-clamp-2 w-full  text-h4">
                        {post.title}
                      </p>
                    </div>
                  </Link>
                ))}
              </div>
              <PostCategorySlider
                data={data?.data ?? []}
                isLoading={isLoading}
              />
            </>
          )}
        </div>
      </div>
    </div>
  );
}

export default PostDetail;
