import {
  usePostCategoriesQuery,
} from "@/src/hooks/Queries";

import React from "react";

interface Props {
  onChangeCategories: (category: string) => void;
  defaultCategory?: string;
}
function FoodsSideBar({ onChangeCategories, defaultCategory }: Props) {
  const { data: categories } = usePostCategoriesQuery();

  return (
    <div className="flex h-max w-full flex-col rounded-half border border-black/5  bg-white  p-6 lg:max-w-xs">
      <div
        className={`flex flex-col  overflow-auto  transition-max-height   duration-700 ease-in-out  `}
      >
        <button
          onClick={() => onChangeCategories("")}
          className={`mb-2 w-full px-2 text-right text-h4 ${
            !defaultCategory && "font-bold"
          }`}
        >
          همه دسته بندی ها
        </button>{" "}
        {categories?.map((item) => (
          <button
            key={item.id}
            onClick={() => onChangeCategories(item.id)}
            className={`mb-2 flex w-full gap-1 px-2  text-right text-h3 ${
              item.id.toString() === defaultCategory && "font-bold"
            }`}
          >
            {item.title}
          </button>
        ))}
      </div>
    </div>
  );
}

export default FoodsSideBar;
