"use client";

import React from "react";
import { FoodDetail } from "@/src/types/food";
import ProductDetail from "./ProductDetail";
import ProductCommentsSlider from "./ProductCommentsSlider";
import ProductDescription from "./ProductDescription";

interface Props {
  productData: FoodDetail;
}
function ProductPage({ productData }: Props) {
  return (
    <>
      <div className="container flex flex-col gap-20 py-8 ">
        <ProductDetail productData={productData} />
        <ProductDescription description={productData.description} />
        <ProductCommentsSlider
          title={productData.title}
          foodId={productData.id}
        />
      </div>
    </>
  );
}

export default ProductPage;
