import React from "react";
import { CSSObjectWithLabel } from "react-select";
import AsyncSelect from "react-select/async";
import { getLocationFromAddressFromLocation } from "@/src/app/actions";
import { useDebouncedCallback } from "use-debounce";
import { LatLngExpression } from "leaflet";

const styles = {
  container: (base: CSSObjectWithLabel) => ({
    ...base,
    width: "100%",
  }),
  control: (base: CSSObjectWithLabel) => ({
    ...base,
    width: "100%",
    fontSize: "12px",
    borderColor: "#0000001A",
    boxShadow: "none",
    borderRadius: 8,
    backgroundColor: "rgba(255, 255, 255, 0.9)",
    ":hover": {
      borderColor: "#0000001A",
    },
  }),
  valueContainer: (base: CSSObjectWithLabel) => ({
    ...base,
    flex: "1 1 auto",
  }),
  input: (base: CSSObjectWithLabel) => ({
    ...base,
    width: "100%",
    margin: 0,
    padding: 0,
  }),
  menu: (base: CSSObjectWithLabel) => ({
    ...base,
    width: "100%",
    zIndex: 500,
  }),
  option: (base: CSSObjectWithLabel, state: any) => ({
    ...base,
    backgroundColor: state.isFocused ? "#F3F4F6" : undefined,
    ":hover": {
      ...base[":hover"],
      backgroundColor: "#F3F4F6",
    },
    ":active": {
      ...base[":active"],
      backgroundColor: "#F3F4F6",
    },
  }),
};
interface Props {
  // center: LatLng;
  onSelect: (value: LatLngExpression) => void;
}
function AddressFormSearch({ onSelect }: Props) {
  const promiseOptions = useDebouncedCallback(async (inputValue: string) => {
    const options = await getLocationFromAddressFromLocation(inputValue);
    return options;
  }, 500);
  return (
    <div className="absolute top-3 left-0 right-0 z-50 px-3">
      <AsyncSelect
        cacheOptions
        onChange={(item) =>
          onSelect({
            lat: item?.location.y ?? 0,
            lng: item?.location.x ?? 0,
          })
        }
        defaultOptions
        loadingMessage={() => "درحال جستجو..."}
        noOptionsMessage={() => "آدرسی یافت نشد !"}
        styles={styles}
        loadOptions={promiseOptions}
        placeholder="جستجو..."
        name="address"
      />
    </div>
  );
}

export default AddressFormSearch;
