import { OrderMenuItems } from "@/src/constants/MenuItems";
import { OrderItems } from "@/src/types/general";
import React from "react";
import { twMerge } from "tailwind-merge";

interface Props {
  activeTap: OrderItems;
  onItemClick: (id: OrderItems) => void;
}
function OrderHeader({ activeTap, onItemClick }: Props) {
  return (
    <div className="border-b border-gray-200 text-center text-h4  ">
      <ul className="-mb-px flex flex-wrap">
        {OrderMenuItems.map((item) => (
          <li className="me-4" key={item.id}>
            <button
              onClick={() => onItemClick(item.id)}
              className={twMerge(
                "inline-block rounded-t-3  p-8  hover:text-gray-600 ",
                activeTap === item.id ? "border-b-4 border-primary" : ""
              )}
            >
              {item.title}
            </button>
          </li>
        ))}
      </ul>
    </div>
  );
}

export default OrderHeader;
