import { Order } from "@/src/types/Cart";

import React, { useState } from "react";
import NextImg from "@/src/components/NextImage";
import emptyImage from "@/public/assets/images/default/no-order.svg";
import { useSnackbar } from "notistack";
import { Modal } from "@/src/components/Modal";
import OrderCard from "../OrderCard";
import OrderDetailCard from "../OrderDetailCard";
import { CommentForm } from "../CommentForm";

interface Props {
  orders: Order[];
  isLoading: boolean;
  onComment: VoidFunction;
}

function CurrentOrders({ orders, isLoading, onComment }: Props) {
  const [selectedOrder, setSelectedOrder] = useState<Order | null>();
  const [commentOrder, setCommentOrder] = useState<Order | null>();
  const { enqueueSnackbar } = useSnackbar();
  const RepayHandler = (order: Order) => {
    try {
      window.location.href = `${process.env.NEXT_PUBLIC_DOMAIN}/payment/pay_order?code=${order.gatewayCode}&has_wallet=true&gateway_id=1`;
    } catch (error) {
      console.log(error);
      enqueueSnackbar("خطا در پرداخت", {
        variant: "error",
      });
    }
  };
  return (
    <div className="flex w-full flex-col gap-8">
      {!selectedOrder ? (
        orders.map((item, index) => (
          <OrderCard
            onCLick={() => setSelectedOrder(item)}
            item={item}
            onPay={() => RepayHandler(item)}
            key={index}
            onComment={() => setCommentOrder(item)}
          />
        ))
      ) : (
        <OrderDetailCard
          onComment={() => setCommentOrder(selectedOrder)}
          order={selectedOrder}
          onBack={() => setSelectedOrder(null)}
        />
      )}
      {!isLoading && !orders.length && (
        <div className="flex flex-col items-center justify-center gap-3 py-4">
          <NextImg src={emptyImage} alt="no-address" width={115} height={140} />
          <p className="text-h3">تاکنون سفارشی برای شما ثبت نشده است.</p>
        </div>
      )}
      <Modal
        open={!!commentOrder}
        title="نظر خود را ثبت کنید."
        wrapperClassName="max-w-lg w-full"
        onClose={() => setCommentOrder(undefined)}
      >
        {commentOrder && (
          <CommentForm
            onVerify={() => {
              onComment();
              setCommentOrder(undefined);
            }}
            order={commentOrder}
          />
        )}
      </Modal>
    </div>
  );
}

export default CurrentOrders;
