import Button from "@/src/components/Button";
import NextImg from "@/src/components/NextImage";
import { Order } from "@/src/types/Cart";
import { numberWithCommas } from "@/src/utils/Helpers";
import { ArrowRight } from "iconsax-react";

import React from "react";

interface Props {
  order: Order;
  onBack: VoidFunction;
  onComment: VoidFunction;
}

function OrderDetailCard({ order, onBack, onComment }: Props) {
  return (
    <div className="rounded-half border border-text-secondary">
      <div className="flex items-center border-b border-black/20 p-12 text-h3 font-bold ">
        <button className="flex gap-4">
          <ArrowRight onClick={onBack} />
          جزئیات سفارش
        </button>
      </div>
      <div className=" grid w-full grid-cols-3 gap-y-8  border-b border-black/20 p-12 *:flex  *:flex-col lg:grid-cols-4">
        <p>
          شماره سفارش: <span>{order.id}</span>
        </p>
        <p>
          تاریخ :<span>{order.date}</span>
        </p>
        <p>
          مبلغ:
          <span>{numberWithCommas(order.pricing.total)} تومان</span>
        </p>
        <p>
          هزینه ارسال:
          <span>{numberWithCommas(order.pricing.sendPrice)} تومان</span>
        </p>
      </div>
      <div className="flex flex-col items-center gap-28 border-b border-black/20 p-12 ">
        {order.cart.map((item) => (
          <div
            key={item.variety.varietyID}
            className="flex w-full justify-between text-h4 "
          >
            <div className="flex items-center gap-4">
              <div className="size-15">
                <NextImg
                  imgWrapperClassName="rounded-base overflow-hidden"
                  alt={item.food.title}
                  key={item.food.chefID}
                  width={30}
                  height={30}
                  src={item.variety.image ?? ""}
                />
              </div>
              <div>
                <p>{item?.food?.title ?? "--"}</p>
                <p className="text-h5">{item.variety.title}</p>
              </div>
            </div>
            <div className="flex justify-end gap-2">
              {" "}
              <span> x {item.count} </span>
              <span>{numberWithCommas(item.variety.price)} تومان</span>
            </div>
          </div>
        ))}
      </div>
      {order.status === "delivered" && !order.hasComment && (
        <div className="flex items-center justify-end gap-28 border-b border-black/20 p-12 ">
          <Button onClick={onComment} className="px-12">
            ثبت نظر
          </Button>
        </div>
      )}
    </div>
  );
}

export default OrderDetailCard;
