import React from "react";
import { parseAsString, useQueryState } from "next-usequerystate";
import { OrderItems } from "@/src/types/general";
import OrderHeader from "./OrderHeader";
import OrderTabs from "./OrderTabs";

function Order() {
  const [activeMenu, setActiveMenu] = useQueryState(
    "orderTap",
    parseAsString.withDefault("current")
  );
  return (
    <div className="flex flex-col ">
      <p className="text-h3 font-bold ">سفارشات</p>

      <div>
        <OrderHeader
          onItemClick={(id) => setActiveMenu(id)}
          activeTap={activeMenu as OrderItems}
        />
      </div>
      <OrderTabs activeTab={activeMenu as OrderItems} />
    </div>
  );
}

export default Order;
