import React, { useState } from "react";
import { usePaginatedTicketQuery } from "@/src/hooks/Queries";
import LoaderSpinner from "@/src/components/LoaderSpinner";
import { useToggle } from "@uidotdev/usehooks";
import TicketForm from "./TicketForm";
import TicketList from "./TicketList";
import TicketDetail from "./TicketDetail";

function Tickets() {
  const { data, isLoading, refetch } = usePaginatedTicketQuery({
    page: 1,
  });
  const [createMode, setCreateMode] = useToggle(false);
  const [ticketId, setTicketId] = useState("");
  return (
    <div className="flex flex-col gap-4">
      {!ticketId && (
        <div className="flex w-full items-center justify-between border-b border-black/20  pb-8">
          <p className="text-h3 ">تیکت و پشتیبانی</p>

          {data && data.total !== 0 && (
            <button
              onClick={() => setCreateMode(!createMode)}
              className="hover:text-bold flex items-center justify-center whitespace-nowrap rounded-half border border-primary px-12 py-4 text-h3  text-primary transition-all  hover:bg-error-extraLight"
            >
              {createMode ? " لیست تیکت ها" : "ثبت تیکت جدید"}
            </button>
          )}
        </div>
      )}
      {isLoading && <LoaderSpinner />}

      <>
        {ticketId ? (
          <TicketDetail ticketId={ticketId} onBack={() => setTicketId("")} />
        ) : (
          <>
            {createMode || (data && data.total === 0) ? (
              <TicketForm
                onAddTicket={() => {
                  setCreateMode(false);
                  refetch();
                }}
              />
            ) : (
              <TicketList
                isLoading={isLoading}
                data={data?.data ?? []}
                onClickItem={(id) => setTicketId(id)}
              />
            )}
          </>
        )}
      </>
    </div>
  );
}

export default Tickets;
