import { useTransactionsQuery } from "@/src/hooks/Queries";
import { numberWithCommas } from "@/src/utils/Helpers";
import moment from "jalali-moment";
import React from "react";

function Transactions() {
  const { data, isLoading } = useTransactionsQuery({
    page: 1,
  });

  return (
    <div className="flex py-2">
      <table className="border-clack/20 w-full border">
        <thead>
          <tr className="border-clack/20 *:border-clack/20 border text-right text-h4 font-normal *:rounded-base *:border  *:px-1 *:py-2 ">
            <th>تاریخ</th>
            <th>نوع تراکنش</th>
            <th>مبلغ</th>
            <th>توضیحات</th>
          </tr>
        </thead>
        <tbody>
          {!isLoading && !data?.data.length && (
            <tr className="border-clack/20 rounded-base border text-right">
              <td
                colSpan={4}
                className=" border-clack/20 truncate rounded-base border  px-1 py-2 text-center text-hero font-bold"
              >
                تراکنشی موجود نیست !
              </td>
            </tr>
          )}
          {data?.data.map((item) => (
            <tr
              key={item.id}
              className="border-clack/20 rounded-base border text-right"
            >
              <td className=" border-clack/20 truncate rounded-base border px-1 py-2 text-right">
                {moment(item.date).locale("fa").format("HH:mm - YYYY/MM/DD")}
              </td>

              <td className=" border-clack/20 border px-1 py-2  text-right">
                {item.transaction_type}
              </td>
              <td
                className={` border-clack/20 border px-1 py-2  text-right ${
                  item.amount <= 0 ? "text-secondary" : "text-Success-light"
                }`}
              >
                {numberWithCommas(item.amount)} تومان
              </td>
              <td className=" border-clack/20 border px-1 py-2 text-center  ">
                {item?.description || "--"}
              </td>
            </tr>
          ))}
        </tbody>
      </table>
    </div>
  );
}

export default Transactions;
