import { useQuery, useQueryClient } from "@tanstack/react-query";
import { Order, Pricing } from "@/src/types/Cart";
import { useCart } from "../UseCart";
import { useState } from "react";

function UseCartQuery() {
  const { getCart } = useCart();
  const queryClient = useQueryClient();
  const queryKey = ["cartList"];
  const queryData = useQuery({
    queryKey,
    queryFn: () => getCart(),
    refetchOnWindowFocus: false,
  });
  const [isManualFetching, setIsManualFetching] = useState(false);

  // Refetch with new parameters (e.g. after address or delivery change)
  const refetchWithParamsWithItem = async (params: {
    delivery_type_id?: string;
    address_id?: string;
    branch_id?: string;
  }) => {
    try {
      setIsManualFetching(true);
      const result = await getCart(params);
      queryClient.setQueryData(queryKey, result);
    } finally {
      setIsManualFetching(false);
    }
  };

  const updatePriceWithDiscountedPrice = async (discountedPrice: number) => {
    queryClient.setQueryData(
      queryKey,
      (data: Order): Order => ({
        ...data,
        pricing: {
          ...data.pricing,
          orderTotal: data.pricing.orderTotal - discountedPrice,
          discountedPrice,
        },
      })
    );
  };
  const updatePricing = async (pricing: Pricing) => {
    queryClient.setQueryData(
      queryKey,
      (data: Order): Order => ({
        ...data,
        pricing: {
          ...pricing,
        },
      })
    );
  };

  return {
    queryData,
    refetch: queryData.refetch,
    refetchWithParamsWithItem,
    updatePriceWithDiscountedPrice,
    updatePricing,
    isManualFetching,  
  };
}

export default UseCartQuery;
