import { useQuery } from "@tanstack/react-query";
import { useChefs } from "../UseChefs";

function UseChefTimeQuery(chefID: string) {
  const { getChefAvailableTime } = useChefs();

  const queryData = useQuery({
    queryKey: ["chefTime", chefID],
    queryFn: () => getChefAvailableTime(chefID),
    staleTime: Infinity,
  });

  return queryData;
}

export default UseChefTimeQuery;
