import { useQuery } from "@tanstack/react-query";

import { useAddress } from "../UseAddress";

function UseChildAreasQuery(areaId?: string) {
  const { getAreas } = useAddress();

  const queryData = useQuery({
    queryKey: ["getChildAreas", areaId],
    queryFn: () => getAreas(areaId),
    staleTime: Infinity,
    enabled: !!areaId,
  });

  return queryData;
}

export default UseChildAreasQuery;
