import { keepPreviousData, useQuery } from "@tanstack/react-query";
import { useDiscounts } from "../UseDiscounts";

interface Props {
  page?: number;
}

function UseDiscountQuery({ page }: Props) {
  const { userDiscounts } = useDiscounts();

  const queryKey = ["userDiscounts", page];
  const queryData = useQuery({
    queryKey,
    placeholderData: keepPreviousData,
    queryFn: () => userDiscounts(page),
    refetchOnWindowFocus: false,
  });

  return queryData;
}

export default UseDiscountQuery;
