import { keepPreviousData, useQuery } from "@tanstack/react-query";
import { getPostsService } from "@/src/services/httpServices/PostServices";
import { Post } from "@/src/types/Post";
import { PaginationResult } from "@/src/types/general";

interface Props {
  categoryID?: string;

  title?: string;
  page?: number;
  prePage?: number;
}
function UsePostsListQuery({
  categoryID,
  page = 1,

  title,

  prePage,
}: Props) {
  const queryData = useQuery({
    queryKey: ["postsList", categoryID, page, title, prePage],
    queryFn: () =>
      getPostsService({
        title,
        post_category_id: categoryID,
        page,
        paginate: prePage ?? 16,
      }),
    placeholderData: keepPreviousData,
    select: (data): PaginationResult<Post> => ({
      currentPage: data.current_page,
      perPage: data.per_page,
      total: data.total,
      totalPages: data.last_page,
      data: data.data.map((postDetail) => ({
        author: postDetail.author,
        category: postDetail.post_category,
        content: postDetail.content,
        cover: postDetail.cover,
        id: postDetail.id,
        title: postDetail.title,
      })),
    }),
    refetchOnWindowFocus: false,
    throwOnError: true,
  });

  return queryData;
}

export default UsePostsListQuery;
