import { useQuery } from "@tanstack/react-query";

import { useTicket } from "../UseTicket";

function UseTicketDetailQuery(id: string) {
  const { getTicketsDetail } = useTicket();

  const queryData = useQuery({
    queryKey: ["ticketDetail", id],
    queryFn: () => getTicketsDetail(id),
  });

  return queryData;
}

export default UseTicketDetailQuery;
