import { useState } from "react";
import { deleteActiveOrderService } from "@/src/services/httpServices/CartServices";
import { enqueueSnackbar } from "notistack";
import { useCartStore } from "@/src/store";
import { useSelectionStore } from "@/src/store/useSelectionStore";
import Cookies from "js-cookie";

export const useDeleteActiveOrder = () => {
  const [isLoading, setIsLoading] = useState(false);
  const { resetCard } = useCartStore();
  const { clearSelection } = useSelectionStore();

  const deleteActiveOrder = async (userId: number, restaurantId?: string) => {
    try {
      setIsLoading(true);
      await deleteActiveOrderService(userId);
      
      // Clear all stored cart data
      resetCard(); // Clear cart store
      
      // Clear selection store for the restaurant if provided
      if (restaurantId) {
        clearSelection(restaurantId);
      }
      
      // Clear localStorage items related to cart
      localStorage.removeItem("has_address");
      localStorage.removeItem("unsavedAddress");
      
      // Clear guest token if exists
      Cookies.remove("Guest-token");
      
      enqueueSnackbar("سفارش فعال با موفقیت حذف شد", {
        variant: "success",
      });
      return true;
    } catch (error) {
      enqueueSnackbar(error?.message ?? "خطا در حذف سفارش فعال", {
        variant: "error",
      });
      throw error;
    } finally {
      setIsLoading(false);
    }
  };

  return {
    deleteActiveOrder,
    isLoading,
  };
};