import {
  getProductCommentsService,
  getChefCommentsService,
  getChefCommentsRateService,
  sendCommentService,
} from "@/src/services/httpServices/CommentService";
import { ApiSetComment } from "@/src/services/httpServices/CommentService/types";
import { Comment, CommentFormFields } from "@/src/types/Comment";
import { useState } from "react";

function UseComments() {
  const [isLoading, setIsLoading] = useState(false);

  const getFoodComments = async (foodID: string) => {
    try {
      setIsLoading(true);
      const result = await getProductCommentsService(foodID);

      const modeledUser: Comment[] = result.map((item) => ({
        id: item.id,
        content: item.text,
        rate: item.rate,
        products: item.products,
        date: item.created_at,
        user: `${item.user.name} ${item.user.family}`,
      }));

      return modeledUser;
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };
  const getChefComments = async (chefID: string) => {
    try {
      setIsLoading(true);
      const result = await getChefCommentsService(chefID);

      const modeledUser: Comment[] = result.map((item) => ({
        id: item.id,
        content: item.text,
        rate: item.rate,
        products: item.products,
        date: item.created_at,
        user: item.user ? `${item.user.name} ${item.user.family}` : "کاربر",
      }));

      return modeledUser;
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };
  const getChefRate = async (chefID: string) => {
    try {
      setIsLoading(true);
      const result = await getChefCommentsRateService(chefID);

      return result;
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };

  const sendComment = async (orderID: string, data: CommentFormFields) => {
    try {
      setIsLoading(true);
      const commentData: ApiSetComment = {
        text: data.content,
        rates: data.cartItems.map((item) => ({
          id: +item.id,
          rate: item.rate,
        })),
      };
      await sendCommentService(orderID, commentData);
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };
  return {
    isLoading,
    getFoodComments,
    getChefComments,
    getChefRate,
    sendComment,
  };
}

export default UseComments;
