import { getDiscountsService } from "@/src/services/httpServices/DiscountServices";
import { Discount } from "@/src/types/Cart";
import { PaginationResult } from "@/src/types/general";
import { useState } from "react";

function UseTransactions() {
  const [isLoading, setIsLoading] = useState(false);

  const userDiscounts = async (page: number = 1) => {
    try {
      setIsLoading(true);
      const res = await getDiscountsService({
        page,
        paginate: 10,
      });
      const result: PaginationResult<Discount> = {
        currentPage: res.current_page,
        perPage: res.per_page,
        total: res.total,
        totalPages: res.last_page,
        data: res.data.map((item) => ({
          chefTitle: item.branch?.title ?? "",
          code: item.code,
          expireDate: item.active_to,
          maxOrderPrice: item.max_price_discount,
          minOrderPrice: item.min_price_order,
          title: item.title,
          percent: item.percent,
        })),
      };
      return result;
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };

  return {
    isLoading,
    userDiscounts,
  };
}

export default UseTransactions;
