import { apiEndpoints } from "@/src/constants/Endpoints";
import { OrderItems } from "@/src/types/general";
import { httpService } from "../httpService";
import {
  APICart,
  ApiCheckDiscount,
  ApiDiscount,
  ApiGateways,
  ApiUpdateCart,
  ApiOrder,
  ApiDeliveryTypes,
  ApiSetAddress,
  ApiSetDelivery,
  ApiAddCart,
  ApiCartResult,
  ApiRemoveCart,
  ServiceDetails,
  ApiSetAddressByLocation,
} from "./types";
import { ApiAvailableTime } from "../ChefService/types";
import { DeliveryDetails } from "@/src/hooks/Queries/useDeliveryMethodByTime";

const { cart, user, chef, area } = apiEndpoints;

export const updateCartService = (data: ApiUpdateCart) =>
  httpService.post(cart.updateWithList, data);
export const getCartService = (params?: {
  delivery_type_id?: string;
  address_id?: string;
  branch_id?: string;
}): Promise<APICart> => httpService.get(cart.getCart, { params });

export const getAreaAddressService = (
  data: ApiSetAddress
): Promise<ServiceDetails> => {
  const params = new URLSearchParams();

  if (data.address_id) params.append("address_id", data.address_id);
  if (data.branch_id) params.append("branch_id", data.branch_id);
  if (data.lat) params.append("lat", data.lat);
  if (data.lng) params.append("lng", data.lng);

  return httpService.get(
    `${area.setAreaAddress}?${params.toString()}`,
    undefined,
    false
  );
};

export const getDeliveryMethodByTimeService = (
  data: ApiSetAddressByLocation
): Promise<DeliveryDetails> => {
  const params = new URLSearchParams();

  params.append("branch_id", String(data.branch_id));

  if (data.time) {
    params.append("time", data.time);
  }

  if (data.day) {
    params.append("day", data.day);
  }

  return httpService.get(
    `${area.deliveryMethodByAddress}?${params.toString()}`,
    undefined,
    false
  );
};

export const setDeliveryService = (data: ApiSetDelivery): Promise<APICart> =>
  httpService.post(`${cart.setDelivery}`, data);
export const CheckDiscountService = (
  data: ApiCheckDiscount
): Promise<ApiDiscount> =>
  httpService.get(`${cart.checkDiscountCode}`, {
    params: data,
  });
export const getGatewaysService = (): Promise<ApiGateways[]> =>
  httpService.get(cart.getGateways);
export const getOrderAvailableTimeService = (
  chefID: string,
  date: string
): Promise<ApiAvailableTime> =>
  httpService.post(cart.checkDate, {
    date,
    branchId: chefID,
  });
export const setOrderFinalService = (
  date: string,
  coupon?: string,
  description?: string
): Promise<ApiOrder> =>
  httpService.post(cart.setOrder, {
    ...(coupon && {
      coupon,
    }),
    ...(date && {
      delivery_time: date,
    }),
    ...(description && {
      description,
    }),
  });
export const getUserOrdersService = (status: OrderItems): Promise<ApiOrder[]> =>
  httpService.get(user.getUserOrder, {
    params: {
      ...(status !== "current" && {
        status,
      }),
    },
  });
export const getOrderService = (orderId: string): Promise<ApiOrder> =>
  httpService.get(`${cart.base}${orderId}`);
export const getDeliveryTypesService = (
  branchId: string
): Promise<ApiDeliveryTypes[]> =>
  httpService.get(`${area.deliveryTypes}?branch_id=${branchId}`);
export const AddToCartService = (data: ApiAddCart): Promise<ApiCartResult> =>
  httpService.post(cart.add, data);
export const RemoveFromCartService = (
  data: ApiRemoveCart
): Promise<ApiCartResult> => httpService.put(cart.remove, data);

export const deleteActiveOrderService = (userId: number): Promise<any> =>
  httpService.delete(cart.deleteActiveOrder, { data: { user_id: userId } });
