import { ApiTimeStampData } from "@/src/types/general";

export enum ApiTransactionVariant {
  CHARGE = "charge",
  ORDER = "pay_order",
  SALES = "sales",
  SALES_PROFIT = "sales_profit",
  DELIVER_PROFIT = "deliver_profit",
  DELIVER = "deliver",
}
export type ApiTransactionType =
  (typeof ApiTransactionVariant)[keyof typeof ApiTransactionVariant];
interface ApiDiscountBranch {
  id: number;
  title: string;
}

export interface ApiDiscountItem extends ApiTimeStampData {
  id: string;
  title: string;
  code: string;
  branch_id: string;
  type: number;
  percent: number;
  price: string;
  active_from: Date;
  active_to: Date;
  limit_uses: number;
  used_count: number;
  max_price_discount: number;
  min_price_order: number;
  branch: ApiDiscountBranch;
}
