import {
  ApiFile,
  ApiPaginationResult,
  ApiTimeStampData,
  orderData,
} from "@/src/types/general";
import { ApiCategory } from "../../CategoryServices/types";
import { ApiBranch } from "../../ChefService/types";

export interface ApiExtraType {
  id: number;
  title: string;
  branch_id: string;
}
export interface ApiExtra extends ApiTimeStampData {
  id: number;
  title: string;
  price: number;
  branch_id: string;
  extra_type_id: number;
  description: string;
  extra_type: ApiExtraType;
}
export interface ApiUnit extends ApiTimeStampData {
  id: number;
  title: string;
}
export interface ApiProductMaterialPivot {
  product_id: number;
  material_id: number;
  usage_per_unit: number;
}
export interface ApiMaterial extends ApiTimeStampData {
  id: number;
  title: string;
  unit_id: number;
  price_per_unit: number;
  calorie_per_unit: number;
  image: string;
  pivot: ApiProductMaterialPivot;
  unit: ApiUnit;
}
export interface ApiVariety extends ApiTimeStampData {
  id: string;
  product_id: number;
  title: string;
  min_description: string;
  description: string;
  price: number;
  count: number;
  discount: number;
  order: number;
  discounted_price: number;
  max_order: number;
}

export interface ApiProduct extends ApiTimeStampData {
  id: string;
  branch_id: string;

  langueg_id: number;
  category_id: number;
  rate: number;
  image: string;
  images: ApiFile[] | [];
  title: string;
  description: string;
  varieties: ApiVariety[];
  extra: ApiExtra[];
  material: ApiMaterial[];
  branch: ApiBranch;
  files?: ApiFile[] | [];
  calory?: number;
}
export type ApiProductPaginated = ApiPaginationResult<ApiProduct>;
export interface ApiFoodParams {
  order_by: orderData;
  paginate: number;
  page: number;
  branch_id?: string;
  has_discount?: 0 | 1;
  title?: string;
  category_id?: string;
  lat?: string;
  lon?: string;
}
export interface ApiCategoriesFood extends ApiCategory {
  product_menu: ApiProduct[];
}
export interface ApiFoodCalories {
  energy: number;
  protein: [number, number];
  carbohydrate: [number, number];
  fat: [number, number];
}
