import { BirthDay } from "./auth";
import { ApiFile, orderData } from "./general";

export interface BaseChef {
  id: string;
  title: string;
  logo?: string;
  cover?: string;
  ariaTitle?: string;
  rate?: number;
  FoodsCounts?: number;
  avgPrice?: number;
}

export interface ChefParams {
  order: orderData;
  categoryID?: string;
  page: number;
  lat?:string;
  lng?:string;
  title?: string;
  paginate?: number;
}

export enum WeekdayVariant {
  saturday = "شنبه",
  sunday = "یکشنبه",
  monday = "دوشنبه",
  tuesday = "سه شنبه",
  wednesday = "چهارشنبه",
  thursday = "پنجشنبه",
  friday = "جمعه",
}
export type WeekType = (typeof WeekdayVariant)[keyof typeof WeekdayVariant];
export interface ChefAvailableTime {
  from: string;
  to: string;
}
export interface ChefAvailable {
  time: ChefAvailableTime[];
  title: string;
}
export interface ChefAvailableTimeList {
  monday: ChefAvailable | null;
  tuesday: ChefAvailable | null;
  wednesday: ChefAvailable | null;
  thursday: ChefAvailable | null;
  friday: ChefAvailable | null;
  saturday: ChefAvailable | null;
  sunday: ChefAvailable | null;
}
export interface ApiChefSlider {
  id: string;
  title: string;
  file: ApiFile[] | [];
}

export interface ApiChefPopupAlarm {
  title?: string;
  id:number;
  message?: string;
  image?:string;
  status?:string
}

export interface ChefRegistration {
  name: string;
  family: string;
  nationalCode: string;
  mobile: string;
  phone?: string;
  username?: string;
  birthDay?: BirthDay;
  referralCode?: string;
  address: string;
  instagram?: string;
  telegram?: string;
  youtube?: string;
  national_id_image?: File[]; 
  business_license_image?: File[]; 
}
export interface HomeItems {
  title: string;
  chefs: BaseChef[];
}
export interface ChefDetail extends BaseChef {
  description: string;
  minOrderPrice: number;
  lat: string;
  lng: string;
  address: string;
  minOrder: number;
  nearestOpeningTime: ChefAvailable | null;
  hasPreOrder: boolean;
}
