// react-rating-stars-component.d.ts

declare module "react-rating-stars-component" {
  import * as React from "react";

  interface ReactStarsProps {
    count?: number; // Number of stars (default: 5)
    value?: number; // Current rating value
    size?: number; // Size of each star (default: 30)
    char?: string; // Character to use for the star (default: ★)
    color?: string; // Color of inactive stars (default: 'gray')
    activeColor?: string; // Color of active stars (default: 'yellow')
    a11y?: boolean; // Accessibility flag (default: true)
    isHalf?: boolean; // Whether to allow half stars (default: false)
    emptyIcon?: React.ReactNode; // Custom empty star icon
    halfIcon?: React.ReactNode; // Custom half star icon
    filledIcon?: React.ReactNode; // Custom filled star icon
    onChange?: (newValue: number) => void; // Callback function when rating changes
    edit?: boolean; // Whether the stars are editable (default: true)
    classNames?: string; // Custom CSS class names
  }

  const ReactStars: React.FC<ReactStarsProps>;

  export default ReactStars;
}
