import React from "react";
import dynamic from "next/dynamic";

const UserActions = dynamic(() => import("../Header/UserActions"), {
  ssr: false,
});

function MobileHeader() {
  return (
    <div className="block w-full min-w-full border-b border-black/20 bg-white lg:hidden">
      <div className="container flex items-center justify-between gap-4 px-10 py-3 lg:hidden lg:px-0">
        <p className="flex-1 truncate text-sm font-bold text-primary">
          فضایی برای معاشرت،نوشیدن، کار و خاطره سازی ...
        </p>

        <UserActions />
      </div>
    </div>
  );
}

export default MobileHeader;
