import { MetadataRoute } from "next";
import { fetchData } from "./dataFetcher";

export default async function manifest(): Promise<MetadataRoute.Manifest> {
  const data = await fetchData();
  return {
    name: data.settings.title,
    short_name: data.settings.title,
    description: data.settings.smDescription,
    start_url: "/",
    display: "standalone",
    background_color: "#110E28",
    theme_color: "#110E28",
    icons: [
      {
        src: data.settings.faveIcon,
        sizes: "any",
        type: "image/x-icon",
      },
    ],
  };
}
