"use client"

import { CloseCircle } from 'iconsax-react';
import React, { useEffect, useState } from 'react';

interface DrawerProps {
    position?: "bottom" | "left" | "right" | "top"; // Drawer position
    headerTitle?: string
    children: React.ReactNode;
    isOpenDrawer: boolean
}


export default function Drawer({ position = 'bottom', isOpenDrawer = false, children, headerTitle }: DrawerProps) {
    const [isOpen, setIsOpen] = useState(isOpenDrawer);

    const toggleDrawer = () => {
        setIsOpen(!isOpen);
    };
    useEffect(() => {
        setIsOpen(isOpenDrawer);
    }, [isOpenDrawer]);

    // Determine the drawer's position based on the `position` prop
    const getDrawerPosition = () => {
        switch (position) {
            case 'top':
                return `fixed top-0 left-0 right-0 transform transition-transform duration-300 ease-in-out ${isOpen ? 'translate-y-0' : '-translate-y-full'
                    }`;
            case 'left':
                return `fixed top-0 left-0 bottom-0 transform transition-transform duration-300 ease-in-out ${isOpen ? 'translate-x-0' : '-translate-x-full'
                    }`;
            case 'right':
                return `fixed top-0 right-0 bottom-0 transform transition-transform duration-300 ease-in-out ${isOpen ? 'translate-x-0' : 'translate-x-full'
                    }`;
            case 'bottom':
            default:
                return `fixed bottom-0 left-0 right-0 transform transition-transform duration-300 ease-in-out ${isOpen ? 'translate-y-0' : 'translate-y-full'
                    }`;
        }
    };

    return (
        <div className={` ${isOpen ? 'fixed' : ''} inset-0 z-[2000000003]`}>
            {/* Overlay */}
            {isOpen && (
                <div
                    className="fixed inset-0 !bg-black !bg-opacity-20 transition-opacity"
                    onClick={toggleDrawer}
                ></div>
            )}

            {/* Drawer */}
            <div className={getDrawerPosition()}>

                <div className="shadow-lg mx-auto size-full max-w-md rounded-t-large bg-white">
                    <div className="z-10 flex items-center justify-between rounded-t-large border-b border-black/20 px-8 py-6 ">
                        <h3 className="flex-1 text-h5 font-bold">{headerTitle}</h3>
                        <CloseCircle className='cursor-pointer ' onClick={toggleDrawer}
                            size={18}
                        />
                    </div>
                    <div className="p-8">{children}</div>
                </div>
            </div>

            {/* Button to toggle the drawer */}

        </div>
    );
}