"use client";

import { ArrowRight2 } from "iconsax-react";
import React, { useEffect } from "react";

interface Props {
  title?: string;
  open: boolean;
  onClose: VoidFunction;
  children: React.ReactNode;
}

function FullScreenModal(props: Props) {
  const { onClose, title, open = false, children } = props;

  useEffect(() => {
    if (open) {
      document.body.style.overflow = "hidden";
    } else {
      document.body.style.overflow = "auto";
    }
  }, [open]);

  return (
    <div
      tabIndex={-1}
      className={` transition-opacity duration-300  ${
        open ? "opacity-100" : "pointer-events-none opacity-0"
      } fixed  inset-0 z-50  h-screen w-full  bg-white ease-in-out`}
    >
      <div className="flex items-center  justify-start gap-8  py-8 text-h3 font-bold lg:hidden">
        <button onClick={onClose} className="flex  items-center gap-2 px-8">
          <ArrowRight2 />

          {title}
        </button>
      </div>
      {open && (
        <div className="  w-full space-y-8 overflow-auto px-4 pb-4 ">
          {children}
        </div>
      )}
    </div>
  );
}

export { FullScreenModal };
