"use client";

import { CloseCircle } from "iconsax-react";
import React, { useCallback, useEffect } from "react";
import { twMerge } from "tailwind-merge";

interface Props {
  title?: string;
  wrapperClassName?: string;
  inlineClassName?:string
  open: boolean;
  onClose: VoidFunction;
  children: React.ReactNode;
}

function Modal(props: Props) {
  const { onClose, title, open = false, children, wrapperClassName,inlineClassName } = props;

  useEffect(() => {
    if (open) {
      document.body.style.overflow = "hidden";
    } else {
      document.body.style.overflow = "auto";
    }
  }, [open]);
  const handleBackdropClick = useCallback(
    (event: React.MouseEvent<HTMLDivElement>) => {
      // Check if the click is outside the modal content
      if (event.target === event.currentTarget) {
        onClose();
      }
    },
    [onClose]
  );
  return (
    <div
      id="modal"
      data-modal-backdrop="static"
      tabIndex={-1}
      aria-hidden="true"
      className={`fixed  inset-0 z-[60] flex items-center justify-center  ${
        open ? "opacity-100" : "pointer-events-none opacity-0"
      } bg-gray-800/50  transition-opacity duration-300  ease-in-out`}
      onClick={handleBackdropClick} // Add the click handler here
    >
      <div className="relative mx-auto flex min-h-full w-full max-w-2xl items-center justify-center">
        {/* <!-- Modal content --> */}
        <div
          className={twMerge(
            "shadow relative max-h-svh overflow-auto rounded-1 bg-white",
            wrapperClassName
          )}
        >
          {/* <!-- Modal header --> */}
          <div className="rounded-t flex items-center justify-between border-b border-black/20 px-8 py-6 ">
            <h3 className="flex-1    text-h5 font-bold">{title}</h3>
            <button
              onClick={onClose}
              type="button"
              className="ml-auto inline-flex items-center justify-center rounded-1 bg-transparent "
              data-modal-hide="modal"
            >
              <CloseCircle size={18} />
            </button>
          </div>
          {open && (
            <div className={twMerge(
            "space-y-8 overflow-auto  px-8 py-16 ",
            inlineClassName
          )}>
              {children}
            </div>
          )}
        </div>
      </div>
    </div>
  );
}

export { Modal };
