import { LatLngExpression } from "leaflet";
import React, { useState } from "react";
import { Marker, useMapEvents } from "react-leaflet";
import { markerIcon } from "./icon";

interface Props {
  onClick: (lat: string, lng: string) => void;
}

function LocationMarker({ onClick }: Props) {
  const [position, setPosition] = useState<LatLngExpression | undefined>(
    undefined
  );
  useMapEvents({
    click(e) {
      const { latlng } = e;
      setPosition([latlng.lat, latlng.lng]);
      onClick(latlng.lat.toString(), latlng.lng.toString());
    },
  });

  return position && <Marker icon={markerIcon} position={position} />;
}
export { LocationMarker };
