"use client";

import { useState } from "react";

type Item = { name: string; qty: number; price: number };

const items: Item[] = [
  { name: "دونات", qty: 1, price: 60000 },
  { name: "کوفی", qty: 1, price: 55000 },
  { name: "چای", qty: 1, price: 60000 },
  { name: "آب", qty: 1, price: 60000 },
];

function toman(n: number) {
  return n.toLocaleString("fa-IR") + " تومان";
}

export default function OrderPaymentCard() {
  const [open, setOpen] = useState(true);
  const total = 600000; // نمونه؛ هرچه خواستی جایگزین کن
  const restaurantTotal = 870000; // نمونه
  const orderNo = 565000; // نمونه

  return (
    <div dir="rtl" className="rounded-lg shadow-sm w-full max-w-md bg-white">
      <div className="text-neutral-800 space-y-4 mt-8 mt-lg-0 p-6 mb-12">
        <h1 className="text-lg text-center font-semibold">پرداخت سفارش</h1>

        <div className="text-sm grid pt-9">
          <div className="flex items-center justify-between px-8 py-12">
            <span className="text-neutral-600">تاریخ و ساعت:</span>
            <span>{toman(615000)}</span>
          </div>

          <div className="rounded-md bg-neutral-50 flex items-center justify-between rounded-1 bg-[#f6f6f6] px-8 py-12">
            <span className="text-neutral-600">شماره سفارش:</span>
            <span>{toman(orderNo)}</span>
          </div>

          <div className="flex items-center justify-between px-8 py-12">
            <span className="text-neutral-600">رستوران / کافه:</span>
            <span>{toman(restaurantTotal)}</span>
          </div>

          {/* Accordion */}
          <div className="rounded-md rounded-1 bg-[#f6f6f6] px-8 py-8">
            <button
              type="button"
              onClick={() => setOpen((v) => !v)}
              className="text-sm flex w-full items-center justify-between py-2"
              aria-expanded={open}
              aria-controls="order-items"
            >
              <span className="text-neutral-700">لیست سفارشات</span>
              <svg
                className={`h-9 w-9 transition-transform ${open ? "rotate-180" : "rotate-0"}`}
                viewBox="0 0 20 20"
                fill="currentColor"
              >
                <path
                  fillRule="evenodd"
                  d="M5.23 7.21a.75.75 0 011.06.02L10 10.94l3.71-3.71a.75.75 0 111.06 1.06l-4.24 4.24a.75.75 0 01-1.06 0L5.21 8.29a.75.75 0 01.02-1.08z"
                  clipRule="evenodd"
                />
              </svg>
            </button>

            {open && (
              <div id="order-items" className=" bg-neutral-50  pt-8">
                {items.map((it, i) => (
                  <div
                    key={i}
                    className="text-sm flex items-center justify-between py-6"
                  >
                    <span className="text-neutral-700">{it.name}</span>

                    <span className="tabular-nums">
                      <span className="text-neutral-400"> {it.qty} × </span>
                      {toman(it.price)}{" "}
                    </span>
                  </div>
                ))}
              </div>
            )}
          </div>

          <div className="flex items-center justify-between px-8 py-18">
            <span className="text-neutral-600">مبلغ (نهایی):</span>
            <span className="font-semibold">{toman(total)}</span>
          </div>
        </div>

        <button
          className="rounded-md hover:bg-red-800 focus:ring-red-600 w-full rounded-1 bg-primary px-4 py-7 text-white transition focus:outline-none focus:ring-2"
          type="button"
        >
          پرداخت سفارش
        </button>
      </div>
    </div>
  );
}
