import { FormOption } from "@/src/types/general";
import React, { InputHTMLAttributes } from "react";
import { Controller, useFormContext } from "react-hook-form";
import { ClassNameValue, twMerge } from "tailwind-merge";

type RadioButtonProps = InputHTMLAttributes<HTMLInputElement> & {
  name: string;
  options: FormOption[];
  disabled?: boolean;
  className?: ClassNameValue;
  WrapperClassName?: ClassNameValue;
};

export default function RHFRadioButton({
  name,
  options,
  disabled = false,

  WrapperClassName,
  ...other
}: RadioButtonProps) {
  const { control } = useFormContext();

  return (
    <Controller
      name={name}
      control={control}
      render={({ field }) => (
        <div className={twMerge("flex flex-col gap-4", WrapperClassName)}>
          {options.map((option) => (
            <label
              key={option.value}
              className={twMerge(
                "rounded-lg flex cursor-pointer items-center gap-3 p-4",
                field.value === option.value ? "border-primary " : "",
                disabled && "cursor-not-allowed opacity-50"
              )}
            >
              <input
                {...field}
                type="radio"
                value={option.value}
                checked={field.value === option.value}
                onChange={() => {
                  field.onChange(option.value);
                }}
                disabled={disabled}
                className=" size-10 accent-primary"
                {...other}
              />
              <div className="flex flex-col">
                <span className="text-h4 font-semibold">{option.label}</span>
                {option.description && (
                  <span className="text-h5 ">{option.description}</span>
                )}
              </div>
            </label>
          ))}
        </div>
      )}
    />
  );
}
