import React from "react";
import { Star1 } from "iconsax-react";

interface Props {
  count: number;
  size: number;
}
function Rate({ count, size }: Props) {
  const rate = Math.floor(count);
  return Array(5)
    .fill(0)
    .map((_, index) => (
      <Star1
        key={index}
        size={size}
        color="#FFB800"
        variant={index < rate ? "Bold" : "Broken"}
      />
    ));
}

export default Rate;
