import React, { Ref, forwardRef, memo, type SVGProps } from "react";

function SvgFoods(props: SVGProps<SVGSVGElement>, ref: Ref<SVGSVGElement>) {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="1em"
      height="1em"
      fill="none"
      viewBox="0 0 32 32"
      ref={ref}
      className="fill-white"
      {...props}
    >
      <g clipPath="url(#foods_svg__a)">
        <path d="M16 7.125c-4.894 0-8.875 3.981-8.875 8.875s3.981 8.875 8.875 8.875 8.875-3.981 8.875-8.875S20.894 7.125 16 7.125Zm0 16.5c-4.204 0-7.625-3.42-7.625-7.625 0-4.204 3.42-7.625 7.625-7.625 4.204 0 7.625 3.42 7.625 7.625 0 4.204-3.42 7.625-7.625 7.625ZM31.668.073a.625.625 0 0 0-.643.034 11.12 11.12 0 0 0-4.9 9.225v8.11c0 .87.339 1.687.954 2.302l1.171 1.171v9.21c0 1.034.841 1.875 1.875 1.875A1.877 1.877 0 0 0 32 30.125V.625a.625.625 0 0 0-.332-.552Zm-.918 30.052a.626.626 0 0 1-1.25 0v-9.469a.625.625 0 0 0-.183-.442l-1.354-1.354a1.993 1.993 0 0 1-.588-1.419v-8.11a9.869 9.869 0 0 1 3.375-7.437v28.231Z" />
        <path d="M14.566 11.043a.625.625 0 0 0-.82-.33A5.74 5.74 0 0 0 10.255 16a.625.625 0 0 0 1.25 0 4.491 4.491 0 0 1 2.732-4.136.625.625 0 0 0 .33-.82ZM16 10.255h-.032a.625.625 0 0 0 .005 1.25H16a.625.625 0 1 0 0-1.25Zm8.664-2.475A11.9 11.9 0 0 0 16 4.057c-1.905 0-3.726.435-5.412 1.294a.625.625 0 0 0 .567 1.114A10.578 10.578 0 0 1 16 5.307c2.962 0 5.717 1.184 7.757 3.333a.624.624 0 0 0 .884.024.625.625 0 0 0 .023-.884Zm.607 14.744a.625.625 0 0 0-.878.102A10.641 10.641 0 0 1 16 26.693c-2.06 0-4.059-.587-5.781-1.696a.625.625 0 0 0-.677 1.05A11.901 11.901 0 0 0 16 27.944c3.675 0 7.091-1.655 9.373-4.541a.625.625 0 0 0-.102-.878ZM8.497 23.62l-.009-.01a.625.625 0 1 0-.966.793l.006.007.02.024a.623.623 0 0 0 .882.068.625.625 0 0 0 .067-.882ZM7.75 0a.625.625 0 0 0-.625.625v6.75H6V.625a.625.625 0 1 0-1.25 0v6.75H3.624l.001-.01V.625a.625.625 0 1 0-1.25 0v6.75H1.25V.625a.625.625 0 1 0-1.25 0V8.25c0 1.533.93 2.917 2.313 3.515v18.36c0 1.034.84 1.875 1.874 1.875a1.877 1.877 0 0 0 1.875-1.875v-18.36A3.849 3.849 0 0 0 8.376 8.25V.625A.625.625 0 0 0 7.75 0ZM5.264 10.726a.626.626 0 0 0-.452.6v18.799a.626.626 0 0 1-1.25 0V11.327a.625.625 0 0 0-.451-.6 2.591 2.591 0 0 1-1.833-2.102h5.819a2.59 2.59 0 0 1-1.833 2.101Z" />
      </g>
      <defs>
        <clipPath id="foods_svg__a">
          <path d="M0 0h32v32H0z" />
        </clipPath>
      </defs>
    </svg>
  );
}
const ForwardRef = forwardRef(SvgFoods);
const Memo = memo(ForwardRef);
export default Memo;
