export const apiEndpoints = {
  auth: {
    base: "/auth/",

    get sendCode() {
      return `${this.base}send_code`;
    },
    get checkCode() {
      return `${this.base}check_code`;
    },
  },
  user: {
    base: "/user/",

    get getProfile() {
      return `${this.base}get-profile`;
    },
    get updateProfile() {
      return `${this.base}update-profile`;
    },
    get changeAddress() {
      return `${this.base}set-address/`;
    },
    get getWallet() {
      return `${this.base}user-inventory`;
    },
    get ChargeWallet() {
      return `${this.base}set-charge-wallet`;
    },
    get getUserOrder() {
      return `${this.base}get-order-user`;
    },
    get getUserTransactions() {
      return `${this.base}get-transactions`;
    },
    get getUserDiscounts() {
      return `${this.base}get-coupons-active-list`;
    },
  },
  product: {
    base: "/product",
    get getProduct() {
      return `${this.base}/`;
    },
    get getCalories() {
      return `${this.base}/get-calories`;
    },
    get getProductCategoryWithBranch() {
      return `${this.base}/get_category_all_with_branch`;
    },
    get sitemap() {
      return `/sitemap-list-products`;
    },
  },
  category: {
    base: "/category",
    get postCategory() {
      return `post-category`;
    },
  },
  comment: {
    base: "/comment/",
    get branchRate() {
      return `${this.base}branch/rate/`;
    },
    get productComments() {
      return `${this.base}product/`;
    },
    get chefComment() {
      return `${this.base}branch/`;
    },
  },
  chef: {
    base: "/branch",
    get availableNow() {
      return `${this.base}/get-status-now/`;
    },
    get available() {
      return `${this.base}/getActivityTime/`;
    },
    get gallery() {
      return `${this.base}/get-gallery/`;
    },
    get getChef() {
      return `${this.base}/show/`;
    },
    get deliveryTypes() {
      return `${this.base}/delivery-types/`;
    },
    get preOrderTime() {
      return `${this.base}/per-order-time/`;
    },
    get sitemap() {
      return `/sitemap-list-branches`;
    },
  },

  address: {
    base: "/address/",
    get create() {
      return `${this.base}create`;
    },
    get update() {
      return `${this.base}update`;
    },
    get delete() {
      return `${this.base}destroy`;
    },
    get getUserAddress() {
      return `${this.base}get-all`;
    },
  },
  vendor: {
    base: "/vendors/",
    get create() {
      return `${this.base}register`;
    },
  },
  area: {
    base: "/areas",
    get deliveryTypes() {
      return `${this.base}/active-shipping-methods`;
    },
    get userAddressesForDeliveryType() {
      return `${this.base}/user-addresses-for-delivery-type`;
    },
    get setAreaAddress() {
      return `${this.base}/area-management-for-address`;
    },
    get deliveryMethodByAddress() {
      return `${this.base}/delivery-methods-by-time`;
    },

  },
  slider: {
    base: "/slider",
  },
  cart: {
    base: "/order/",
    get add() {
      return `${this.base}cart/add-product`;
    },
    get remove() {
      return `${this.base}cart/mines-product`;
    },
    get updateWithList() {
      return `${this.base}store-or-update-order-with-list`;
    },
    get getCart() {
      return `${this.base}with-items`;
    },
    get getAddress() {
      return `${this.base}list-address`;
    },
    get setAddress() {
      return `${this.base}set-delivery-info`;
    },
    get setDelivery() {
      return `${this.base}change-delivery-type`;
    },
    get checkDiscountCode() {
      return `${this.base}check-coupon`;
    },
    get getGateways() {
      return `${this.base}get-list-gateways`;
    },
    get checkDate() {
      return `${this.base}check-date`;
    },
    get setOrder() {
      return `${this.base}set-order`;
    },
    get setComment() {
      return `${this.base}comment`;
    },
    get deleteActiveOrder() {
      return `${this.base}delete-user-active-order`;
    },
  },
  settings: {
    get homePage() {
      return `/home-setting`;
    },
    get logo() {
      return `/front-logo`;
    },
    get slider() {
      return `/slider`;
    },
    get siteSettings() {
      return `/front-setting`;
    },
    get homeInfo() {
      return `/home-info`;
    },
  },
  ticket: {
    base: "/ticket",
    get create() {
      return `${this.base}/create`;
    },
    get category() {
      return `${this.base}/get-category`;
    },
    get show() {
      return `${this.base}/show`;
    },
  },
  upload: {
    base: "/upload",
  },
  favorite: {
    base: "/favorite/",

    get add() {
      return `${this.base}create`;
    },
    get status() {
      return `${this.base}check-status`;
    },
    get remove() {
      return `${this.base}remove`;
    },
    get branch() {
      return `${this.base}with-type/branch`;
    },
    get products() {
      return `${this.base}with-type/product`;
    },
  },

  pages: {
    base: "/page/",
    get show() {
      return `${this.base}show/`;
    },
  },
  components: {
    base: "/component/",
    get getMainComponents() {
      return `${this.base}get-list-components/main/`;
    },
    get getData() {
      return `${this.base}get-with-code/`;
    },
  },
  post: {
    base: "/post",
    get detail() {
      return `${this.base}/show/`;
    },
  },
};
