"use client";

import { Logo } from "@/src/components/Logo";
import { TextField, FormProvider } from "@/src/components/RHF";
import React, { useEffect, useMemo } from "react";
import { useForm } from "react-hook-form";
import { yupResolver } from "@hookform/resolvers/yup";
import * as Yup from "yup";
import { useAuth, useUrlStore } from "@/src/hooks";
import { redirect, useRouter } from "next/navigation";
import Button from "@/src/components/Button";
import { useAuthStore } from "@/src/store";

interface FormFields {
  name: string;
  family: string;
}

const defaultValues: FormFields = {
  name: "",
  family: "",
};

function Complete() {
  const { updateUser } = useAuth();
  const { authUser } = useAuthStore();
  const { getData } = useUrlStore();

  useEffect(() => {
    if (authUser.name) {
      redirect("/profile");
    }
  }, [authUser]);
  const router = useRouter();
  const registerSchema = useMemo(
    () =>
      Yup.object().shape({
        name: Yup.string().required("لطفا نام خود را وارد نمایید "),
        family: Yup.string().required("لطفا نام خانوادگی خود را وارد نمایید "),
      }),
    // eslint-disable-next-line react-hooks/exhaustive-deps
    []
  );

  const methods = useForm<FormFields>({
    defaultValues,
    resolver: yupResolver(registerSchema),
    mode: "onChange",
  });

  const {
    handleSubmit,
    formState: { isValid, isSubmitting },
  } = methods;

  const onSubmit = handleSubmit(async (data) => {
    try {
      await updateUser(data);
      const callback = getData("callback");
      if (callback) {
        router.replace(callback);
      } else router.refresh();
    } catch (error) {
      console.log(error);
    }
  });

  return (
    <div className="flex w-full flex-col gap-16">
      <div className="flex flex-col items-end justify-end gap-16  ">
        <Logo width={75} height={13} />
      </div>
      <FormProvider methods={methods} onSubmit={onSubmit}>
        <div className="flex flex-col gap-20 ">
          <TextField fullWidth type="text" name="name" label="نام" />{" "}
          <TextField fullWidth type="text" name="family" label="نام خانوادگی" />
          <Button type="submit" isLoading={isSubmitting} disabled={!isValid}>
            ادامه
          </Button>
        </div>
      </FormProvider>
    </div>
  );
}

export default Complete;
