"use client";

import { useSettingsStore } from "@/src/providers/SettingsProvider";

import React from "react";

interface Props {
  children: React.ReactNode;
}

function AuthLayoutPage({ children }: Props) {
  const { authBg } = useSettingsStore((state) => state.settings);

  return (
    <div
      className="flex min-h-screen w-full items-center justify-center bg-auth bg-cover  bg-center bg-repeat-y "
      style={{
        backgroundImage: `url(${authBg})`,
      }}
    >
      <div className="flex w-full max-w-xs  rounded-half bg-white p-8  shadow-4">
        {" "}
        {children}
      </div>
    </div>
  );
}

export default AuthLayoutPage;
