import React, { useCallback, useEffect, useRef, useState } from "react";
import { useCartQuery, useGatewayQuery } from "@/src/hooks/Queries";
import { useCart } from "@/src/hooks";
import { useSnackbar } from "notistack";
import { useCartStore } from "@/src/store";

import Cookies from "js-cookie";
import OrderDetail from "../OrderDetail";
import CartItems from "../CardItems";
import CardFinal from "../CardFinal";
import { ServiceDetails } from "@/src/services/httpServices/CartServices/types";
import { useRestaurantSelection } from "../../useRestaurantSelection";

interface DiscountCode {
  price: number;
  code: string;
}
function CartContent() {
  const {
    queryData: { data, isLoading, refetch },
    updatePriceWithDiscountedPrice,
    refetchWithParamsWithItem,
    updatePricing,
  } = useCartQuery();

  const [step, setStep] = useState<1 | 2>(1);
  const [discountCode, setDiscountCode] = useState<DiscountCode | undefined>(
    undefined
  );
  const [adreessResult, setAdressResult] = useState<ServiceDetails>();
  const [gateway, setGateway] = useState(1);
  const [useWalletPayment, setUseWalletPayment] = useState(false);
  const { selectedDeliveryId, selectedAddressId } = useRestaurantSelection(
    data?.chef.id
  );

  // const [time, setTime] = useState("");

  const {
    setOrderFinal,
    setDelivery: setDeliveryCart,
    isLoading: deliveryLoading,
  } = useCart();
  const { enqueueSnackbar } = useSnackbar();
  const { resetCard, setSynced, delivery, setDelivery } = useCartStore();

  const handleFinishOrder = async (description: string) => {
    try {
      if (delivery && delivery?.isAddress && !data?.address?.id) {
        enqueueSnackbar("آدرسی انتخاب نشده", {
          variant: "error",
        });
        return;
      }
      const codeData = await setOrderFinal("", discountCode?.code, description);
      const { code } = codeData;
      enqueueSnackbar("درحال انتقال به درگاه", {
        variant: "info",
      });

      setSynced(false);
      resetCard();
      Cookies.remove("Guest-token");

      window.location.href = `${process.env.NEXT_PUBLIC_DOMAIN}/payment/pay_order?code=${code}&has_wallet=${useWalletPayment}&gateway_id=${gateway}`;
    } catch (error) {
      enqueueSnackbar(error?.message ?? "خطا در ثبت اطلاعات", {
        variant: "error",
      });
    }
  };
  const handleAddressResult = (result: ServiceDetails) => {
    setAdressResult(result);
    // Optionally update local state, show a snackbar, etc.
  };
  const hasInitialized = useRef(false);

  useEffect(() => {
    // bail out if we've already done this
    if (hasInitialized.current) return;
    hasInitialized.current = true;

    // Use Zustand store's selectedDeliveryId and selectedAddressId
    if (selectedDeliveryId) {
      const addressId = selectedAddressId ?? null;

      setDeliveryCart({
        delivery_type_id: selectedDeliveryId,
        address_id: addressId,
      });
    }
  }, [selectedDeliveryId, selectedAddressId, setDeliveryCart]);

  const CurrentStep = useCallback(() => {
    switch (step) {
      case 1:
        return (
          <CartItems
            onCartChanged={refetch}
            isLoading={isLoading}
            cart={data?.cart ?? []}
            chef={data?.chef ?? { id: "", name: "" }}
          />
        );
      case 2:
        return (
          <CardFinal
            deliveryLoading={deliveryLoading}
            onAddressResult={handleAddressResult}
            delivery={delivery}
            onSetDelivery={async (selectedDeliveryId, selected_address_id) => {
              await refetchWithParamsWithItem({
                address_id: selected_address_id,
                branch_id: data?.chef.id,
                delivery_type_id: selectedDeliveryId,
              });
              const hasAddress = localStorage.getItem("has_address");
              const addressId = hasAddress === "1" ? selectedAddressId : null;

              setTimeout(() => {
                setDeliveryCart({
                  delivery_type_id: selectedDeliveryId,
                  address_id: addressId || null,
                });
              }, 200);

              // updatePricing({
              //   ...price,
              //   ...(discountCode?.code && {
              //     orderTotal: price.orderTotal - discountCode.price,
              //     discountedPrice: discountCode.price,
              //   }),
              // });
              // updatePricing({
              //   ...data?.price,
              //   ...(discountCode?.code && {
              //     orderTotal: price.orderTotal - discountCode.price,
              //     discountedPrice: discountCode.price,
              //   }),
              // });
              // setDelivery(selectedDelivery);
            }}
            chefId={data?.chef.id ?? ""}
            // onSetTime={(orderTime) => setTime(orderTime)}
            // time={time}
            gateway={gateway}
            onSetGateway={(id) => {
              setGateway(id);
            }}
            onBack={() => setStep(1)}
            onSetAddress={({
              delivery_type_id,
              address_id,
              branch_id,
            }: {
              delivery_type_id: string;
              address_id?: string;
              branch_id: string;
            }) => {
              refetchWithParamsWithItem({
                delivery_type_id,
                address_id,
                branch_id,
              });
            }}
            onSetDiscountCode={(price: number, code: string) => {
              updatePriceWithDiscountedPrice(price);
              setDiscountCode({
                code,
                price,
              });
            }}
            address={data?.address}
            discountCode={discountCode?.code ?? ""}
            useWalletPayment={useWalletPayment}
            onSetWalletPayment={setUseWalletPayment}
          />
        );

      default:
        return (
          <CartItems
            onCartChanged={refetch}
            isLoading={isLoading}
            cart={data?.cart ?? []}
            chef={data?.chef ?? { id: "", name: "" }}
          />
        );
    }
  }, [
    step,
    isLoading,
    data,
    gateway,
    discountCode,
    // time,
    delivery,
    deliveryLoading,
    useWalletPayment,
  ]);
  return (
    <div className="flex  w-full flex-col gap-8  lg:flex-row xl:px-50 ">
      <CurrentStep />

      <OrderDetail
        step={step}
        isFinish={!!gateway && step === 2}
        adreessResult={adreessResult}
        onComplete={() => setStep(2)}
        onFinish={(description) => handleFinishOrder(description)}
        isLoading={isLoading}
        pricing={data?.pricing}
      />
    </div>
  );
}

export default CartContent;
