import { OrderDataVariant, orderData } from "@/src/types/general";
import { useSnackbar } from "notistack";
import React from "react";

interface Props {
  onChangeOrder: (type: orderData) => void;
  hasLocationPermission: boolean;
  order: orderData;
}
function ChefOrder({ onChangeOrder, order, hasLocationPermission }: Props) {
  const { enqueueSnackbar } = useSnackbar();

  return (
    <div className="flex h-fit w-full max-w-xs rounded-half  border-black/20 p-8 lg:justify-between lg:border">
      <div className="flex flex-col items-start justify-center gap-8  px-12 text-h4  ">
        <p className="text-h3 font-bold">مرتب سازی</p>
        <button
          className={`${
            order === OrderDataVariant.ASC && "font-bold text-secondary "
          }`}
          onClick={() => {
            if (hasLocationPermission) {
              onChangeOrder(OrderDataVariant.ASC);
            } else {
              enqueueSnackbar("خطا در دسترسی به موقعیت مکانی", {
                variant: "error",
              });
            }
          }}
        >
          نزدیکترین
        </button>
        <button
          className={`${
            order === OrderDataVariant.DESC && "font-bold text-secondary"
          }`}
          onClick={() => onChangeOrder(OrderDataVariant.DESC)}
        >
          جدیدترین
        </button>
        <button
          className={`${
            order === OrderDataVariant.RATE && "font-bold text-secondary"
          }`}
          onClick={() => onChangeOrder(OrderDataVariant.RATE)}
        >
          بالاترین امتیاز
        </button>
      </div>
    </div>
  );
}

export default ChefOrder;
