import { BaseChef } from "@/src/types/Chef";
import { orderData } from "@/src/types/general";
import React from "react";

import Link from "next/link";
import NextImg from "@/src/components/NextImage";
import emptyImage from "@/public/assets/images/default/no-order.svg";
import { useTranslation } from "react-i18next";
import ChefLoader from "../ChefLoader";
import ChefOrder from "../ChefOrder";
import BestChefCard from "../../HomePage/BestChefSlider/BestChefCart";

interface Props {
  chefs: BaseChef[] | [];
  onChangeOrder: (type: orderData) => void;

  order: orderData;
  isLoading: boolean;
  hasLocationPermission: boolean;
}
function ChefsItems({
  chefs,
  onChangeOrder,
  order,

  isLoading,
  hasLocationPermission,
}: Props) {
  const { t } = useTranslation();

  return (
    <div className="flex min-h-[600px] w-full ">
      <div className="flex w-full gap-8">
        <div className="hidden w-full max-w-xs lg:block">
          <ChefOrder
            onChangeOrder={onChangeOrder}
            order={order}
            hasLocationPermission={hasLocationPermission}
          />
        </div>

        <div className="grid h-fit w-full grid-cols-1 gap-x-8 gap-y-16  lg:grid-cols-3 ">
          {isLoading && <ChefLoader />}
          {chefs.map((item) => (
            <Link className="h-fit" href={`/chef/${item.id}`} key={item.id}>
              <BestChefCard
                rate={item.rate ?? 0}
                logo={item?.logo ?? ""}
                cover={item?.cover ?? ""}
                title={item.title}
                ariaTitle={item.ariaTitle ?? ""}
              />
            </Link>
          ))}{" "}
          {!isLoading && !chefs.length && (
            <div className="col-span-3 flex w-full flex-col items-center justify-center gap-12 py-16 ">
              <NextImg
                src={emptyImage}
                alt="no-address"
                width={115}
                height={140}
              />
              <p className="text-h3 ">{t("restaurant_notFound")}</p>
            </div>
          )}
        </div>
      </div>
    </div>
  );
}

export default ChefsItems;
