import React from "react";
import { useMediaQuery } from "@uidotdev/usehooks";
import { orderData } from "@/src/types/general";
import SearchFelid from "@/src/components/SearchFelid";
import ChefOrder from "../../Chefs/ChefOrder";

interface Props {
  onChangeOrder: (type: orderData) => void;
  onSearch: (value: string) => void;
  order: orderData;

  hasLocationPermission: boolean;
}
function FoodFilters({
  hasLocationPermission,
  onChangeOrder,
  onSearch,
  order,
}: Props) {
  const isDesktop = useMediaQuery("only screen and (min-width: 1024px)");

  return (
    <div className="grid w-full grid-cols-1  gap-3  lg:grid-cols-2  ">
      <SearchFelid onSearch={onSearch} />

      {isDesktop && (
        <ChefOrder
          onChangeOrder={onChangeOrder}
          order={order}
          hasLocationPermission={hasLocationPermission}
        />
      )}
    </div>
  );
}

export default FoodFilters;
